#!/bin/bash
#
# This file is part of MorphoDynamX - http://www.MorphoDynamX.org
# Copyright (C) 2012-2021 Richard S. Smith and collaborators.
#
# If you use MorphoDynamX in your work, please cite:
#   http://dx.doi.org/10.7554/eLife.05864
#
# MorphoDynamX is free software, and is licensed under under the terms of the 
# GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
#
# Shell script to start MorphoDynamX with a shell window underneath
# For nVidia optimus cards on laptops, MorphoDynamX needs to called with optirun
#

# mdxCNNPredict.sh <CondaDir> <StegmaierDir> <WorkDir> <FileList> <Segment Yes|No>

__conda_setup="$($1'/bin/conda' 'shell.bash' 'hook' 2> /dev/null)"
. $1/etc/profile.d/conda.sh
unset __conda_setup
conda activate pytorch

origDir=`pwd`
mdxDir=$(dirname "$0")
echo "mdxdir:" $mdxDir
echo "stegdir:" $2
cd "$2"
export PYTHONPATH=$PYTHONPATH:"$2"
python "$mdxDir/mdxPredictApply.py" --data_root $3 --test_list $3/$4 --segment $5
cd "$origDir"
