//
// This file is part of 3DCellAtlas. 
// Copyright (C) 2015 George W. Bassel and collaborators.
//
// If you use 3DCellAtlas in your work, please cite:
//   http://dx.doi.org/10.1105/tpc.15.00175
//
// 3DCellAtlas is an AddOn for MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// 3DCellAtlas and MorphoGraphX are free software, and are licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef CUSTOMMOUSELABEL_HPP
#define CUSTOMMOUSELABEL_HPP
  
#include <CellAtlasConfig.hpp>

#include <QLabel>
#include <QMouseEvent>
#include <QEvent>
#include <QDebug>

class QMouseEvent;

class CellAtlas_EXPORT CustomMouseLabel : public QLabel
{
Q_OBJECT
signals:
    void mousePressed( const QPoint& );
    void mouseReleased( const QPoint& );
    void mouseDouble( const QPoint& );
    void keyPressed( const QString& );
    void mouseMove( const QPoint& );
public:
    CustomMouseLabel( QWidget* parent = 0, Qt::WindowFlags f = 0 );
    CustomMouseLabel( const QString& text, QWidget* parent = 0, Qt::WindowFlags f = 0 );
    virtual ~CustomMouseLabel() {}

    void mousePressEvent( QMouseEvent* event );
    void mouseReleaseEvent( QMouseEvent* event );
    void mouseDoubleClickEvent( QMouseEvent* event );
    void mouseMoveEvent( QMouseEvent* event );
    void keyPressEvent( QKeyEvent* event );

};

#endif
