//
// This file is part of 3DCellAtlasOvule.
// Copyright (C) 2015-2016 George W. Bassel and collaborators.
//
// 3DCellAtlasOvule is an AddOn for MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// MorphoGraphX is free software, and are licensed under under the terms of the
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef HDF5_PROCESS_HPP
#define HDF5_PROCESS_HPP

#include <Process.hpp>

#include <QFileDialog>
#include <QRegExp>
#include <QTreeWidgetItem>

class Ui_HDF5Open;

namespace mgx 
{

  /**
   * \class StackSaveHDF5 HDF5Processes.hpp <HDF5Processes.hpp>
   *
   * Save a stack in HDF5 formats.
   *
   * \ingroup StackProcess
   */
  class StackSaveHDF5 : public Process 
  {
  public:
    StackSaveHDF5(const Process& proc) : Process(proc)
    {
      setName("Stack/System/Save HDF5");
      setDesc("Save a stack into a known 3D image format");
      setIcon(QIcon(":/images/HDF.png"));

      addParm("File Name","Name of the file to save to","");  
      addParm("Store","Store","Main", storeChoice()); 
      addParm("Stack Number","Stack number","0");
      addParm("Data Set Name","HDF5 Data Set Name","/data/image");
      addParm("Compression Level","Compression level, from 0 to 9","5");
    }

    bool initialize(QWidget* parent);

    bool run()
    {
      Stack* stk = stack(parm("Stack Number").toInt());
      Store* store = (stringToWorkStore(parm("Store")) ? stk->work() : stk->main());
      return run(*stk, *store, parm("File Name"), parm("Data Set Name"), parm("Compression Level").toInt());
    }
    bool run(Stack &stack, Store &store, QString fileName, QString dataSetName = "/image", int compressionLevel = 0);
  };


  /**
   * \class StackOpenHDF5 HDF5Processes.hpp <HDF5Processes.hpp>
   *
   * Open a stack in HDF5 formats.
   *
   * \ingroup StackProcess
   */
  class mgx_EXPORT StackOpenHDF5 : public Process {
  public:
    StackOpenHDF5(const Process& proc) : Process(proc)
    {
      setName("Stack/System/Open HDF5");
      setDesc("Open a stack from a known 3D image format");
      setIcon(QIcon(":/images/HDF.png"));

      addParm("File Name", "Name of the HDF5 file to open","");
      addParm("Store", "Store", "Main", storeChoice());
      addParm("Stack Number", "Stack number","0");
      addParm("Data Set Name", "HDF5 Data Set Name","");
    }

    bool initialize(QWidget* parent);

    bool run()
    {
      int stackId = parm("Stack Number").toInt();
      Stack *stk = stack(stackId);
      Store* store = (stringToWorkStore(parm("Store")) ? stk->work() : stk->main());
      bool res = run(stk, store, parm("File Name"), parm("Data Set Name"));
      if(res)
        store->show();
      return res;
    }

    bool run(Stack* stack, Store* store, QString fileName, QString dataSetName);
  
    void centerImage();
  };
}


#endif
