//
// This file is part of MorphoDynamX - http://www.MorphoDynamX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoDynamX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoDynamX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
// Derived from hdf_explorer, Copyright (C) 2016 Pedro Vicente
//
#ifndef HDF5Tree_HPP
#define HDF5Tree_HPP

#include <QTreeWidgetItem>
#include <H5Cpp.h>
#include <visit.hpp>

class hdf_dataset_t;

//
// ItemData
// used by QTreeWidgetItem::setData to store custom data
// contains information to load a dataset from an HDF file:
// 1) the file name
// 2) the dataset name
//
struct ItemData
{
  enum ItemKind { Root, Group, Variable, Attribute };

  ItemData(ItemKind kind, const std::string &file_name, 
                const std::string &item_path, const std::string &item_nm, hdf_dataset_t *dataset) :
    m_file_name(file_name), m_item_path(item_path), m_item_nm(item_nm), m_kind(kind), m_dataset(dataset) {}
  ~ItemData() { delete m_dataset; }

  std::string m_file_name;  // file name
  std::string m_item_nm; // item name to display on tree (leaf)
  std::string m_item_path; // full item path
  ItemKind m_kind; // type of item 
  hdf_dataset_t *m_dataset; // (Variable) HDF variable to display
};
Q_DECLARE_METATYPE(ItemData*);

ItemData* get_item_data(QTreeWidgetItem *item);

using namespace H5;

namespace mgx 
{
  class HDF5Tree
  {
  public:
    HDF5Tree(const QString &fileName, QTreeWidget *item);
    ~HDF5Tree();

    H5O_info_added_t* find_object(haddr_t addr);
    int get_attributes(const std::string& file_name, const std::string& path, const hid_t loc_id, QTreeWidgetItem *tree_item_parent);
    int iterate(const std::string& file_name, const std::string& grp_path, const hid_t loc_id, QTreeWidgetItem *tree_item_parent);

    H5File *h5File = 0;
    h5visit_t m_visit;
    QTreeWidgetItem *firstDataSet = 0;
  };
}


#endif
