//
// This file is part of MorphoDynamX - http://www.MorphoDynamX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoDynamX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoDynamX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
// Derived from hdf_explorer, Copyright (C) 2016 Pedro Vicente
//

#ifndef HDF_ITERATE_HPP
#define HDF_ITERATE_HPP

#include <vector>
#include "hdf5.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////
//h5iterate_t
/////////////////////////////////////////////////////////////////////////////////////////////////////

class h5iterate_t
{
public:
  h5iterate_t()
  {
  }

  // iterate
  int iterate(const char* file_name);

  // HDF5 object information
  std::vector < H5O_info_t > iterate_info;

private:
  // callback function for H5Lvisit_by_name
  static herr_t iterate_link_cb(hid_t loc_id, const char *name, const H5L_info_t *linfo, void *_op_data);
};

#endif
