//
// This file is part of MorphoDynamX - http://www.MorphoDynamX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoDynamX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoDynamX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
// Derived from hdf_explorer, Copyright (C) 2016 Pedro Vicente
//

#ifndef HDF_VISIT_HPP
#define HDF_VISIT_HPP

#include <vector>
#include "hdf5.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////
//h5visit_t
/////////////////////////////////////////////////////////////////////////////////////////////////////

struct H5O_info_added_t
{
  H5O_info_t oinfo;
  size_t added;
};
  

class h5visit_t
{
public:
  h5visit_t()
  {
  }

  // visit
  int visit(const char* file_name);

  // HDF5 object information
  std::vector < H5O_info_added_t > visit_info;

private:
  // callback function for H5Lvisit_by_name
  static herr_t visit_link_cb(hid_t loc_id, const char *name, const H5L_info_t *linfo, void *_op_data);
};

#endif
