//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//

#ifndef CellCluster_H
#define CellCluster_H

#include <Process.hpp>
#include <Geometry.hpp>
#include <Function.hpp>

namespace mgx {


//typedef std::map<int, double> IntDoubleMap;
typedef std::pair<int, float> IntFloatP;
typedef std::pair<std::map<int, double>, QString> TypeFeatureVector;
//typedef std::set<vertex> vtxSet;
//typedef std::vector<double> vec;
//typedef std::pair<int, int> IntInt;
//typedef std::pair<vertex, vertex> VertexPr;
//typedef std::pair<int, vtxSet> IntVtxSetP;
//typedef std::map<IntInt, vtxSet> loopNhbrElem;
//typedef std::pair<QString, IntFloatAttr> TypeFeatureMap; 

// Attr Maps
// map<int, QStringList> selected Features



class CellCluster {
    public:
    CellCluster() {}
    QString folder;
    std::map<QString, IntFloatAttr> measures;
    std::map<QString, Point2d> scales;
    std::set<int> eliFtrs;
    std::set<QString> SelectedFeaturesName;
};




}


#endif
