//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef CorrelationMakerHPP
#define CorrelationMakerHPP

#include "Process.hpp"
#include <QDialog>
#include <memory>
#include <QMessageBox>
#include <QCheckBox>
#include <ui_CorrelationGUI.h>
#include <algorithm>
#include <iosfwd>
#include <memory>
#include <string>
#include <utility>
#include <vector>
using std::string;

namespace mgx
{

struct HistoData{
	std::vector<double> bins;
	std::vector<double> bin_bounds;
	std::vector<double> bin_variance;
	std::vector<double> counts;
	double under_bin;
	double under_count;
	double over_bin;
	double over_count;
	double under_y;
	double under_y_count;
	double over_y;
	double over_y_count;
	int in_first_not_second;
};
struct CorrData{
	std::vector<double> bins;
	std::vector<double> ratios;
	std::vector<double> bin_bounds;
//	std::vector<double> bin_variance;
	std::vector<double> counts;
	double under_bin;
	double under_count;
	double over_bin;
	double over_count;
	double under_y;
	double under_y_count;
	double over_y;
	double over_y_count;
	int in_first_not_second;

};


class CorrelationMaker: public Process
 {
   Q_OBJECT;
   public:
    typedef std::pair<int,double> IntDouble;
    Ui_CorrelationDialog ui;
    QString selectedX, selectedY, selectedCor;
    int bin_num;
    float x_min,x_max;
    float y_min,y_max;
    float bin_width;
     CorrelationMaker(const Process &process): Process(process) 
     {
	    x_min=x_max=y_min=y_max=0;
	    bin_num=10;bin_width=0;
	    
		setName("Mesh/Export/Correlation Exporter");
		setDesc("Bin one attribute map based on another attribute map");
		setIcon(QIcon(":/images/Cluster.png"));

		addParm("Parms String","Parms String","");	    	    
	  }
      bool initialize(QWidget* parent);
      bool OutputHistogram();
      bool PrintHisto(HistoData h, QTextStream *outp, QString bin_by,QString bin);
      bool run()
      {
        Mesh *m1 = currentMesh();
        return run(m1, parm("Parms String"));
      }
      
      bool run(Mesh *m, QString parmsString);

      void getAttrMap(AttrMap<int, double>& data, QString measure);
      HistoData ComputeHistoInformation(AttrMap<int, double> dataX, AttrMap<int, double> dataY);
      CorrData ComputeCorrelationInformation(AttrMap<int, double> dataX, AttrMap<int, double> dataY,AttrMap<int, double> dataZ);


   protected slots:
     void fillMeasures();
//     bool parseParmsString(QString parmsString);
//     QString createParmsString();
     void changeValue();
   protected:
     QDialog * dlg;
 };


}
#endif
