//
// This file is part of 3DCellAtlas. 
// Copyright (C) 2015 George W. Bassel and collaborators.
//
// If you use 3DCellAtlas in your work, please cite:
//   http://dx.doi.org/10.1105/tpc.15.00175
//
// 3DCellAtlas is an AddOn for MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// 3DCellAtlas and MorphoGraphX are free software, and are licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#include "CustomMouseLabelTR.hpp"

CustomMouseLabelTR::CustomMouseLabelTR( QWidget * parent, Qt::WindowFlags f )
    : QLabel( parent, f ) {}

CustomMouseLabelTR::CustomMouseLabelTR( const QString& text, QWidget* parent, Qt::WindowFlags f )
    : QLabel( text, parent, f ) {}

void CustomMouseLabelTR::mousePressEvent( QMouseEvent* event )
{
    const QPoint p = event->pos();
    emit mousePressed( p );
}

void CustomMouseLabelTR::mouseReleaseEvent( QMouseEvent* event )
{
    const QPoint p = event->pos();
    emit mouseReleased( p );
}

void CustomMouseLabelTR::mouseDoubleClickEvent( QMouseEvent* event )
{
    const QPoint p = event->pos();
    emit mouseDouble( p );
}

void CustomMouseLabelTR::mouseMoveEvent( QMouseEvent* event )
{
    const QPoint p = event->pos();
    emit mouseMove( p );
}

void CustomMouseLabelTR::keyPressEvent( QKeyEvent* event )
{
    const QString s = event->text();
    emit keyPressed( event->text() );
}

