//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef HistogramMakerHPP
#define HistogramMakerHPP

#include "Process.hpp"
#include <QDialog>
#include <memory>
#include <QMessageBox>
#include <QCheckBox>
#include <ui_HistogramGUI.h>
#include <algorithm>
#include <iosfwd>
#include <memory>
#include <string>
#include <utility>
#include <vector>
using std::string;

namespace mgx
{

class HistogramMaker: public Process
 {
   Q_OBJECT;
   public:
    typedef std::pair<int,double> IntDouble;
    Ui_HistogramDialog ui;
    QString selectedX, selectedY;
    int bin_num;
    float x_min,x_max;
    float y_min,y_max;
     HistogramMaker(const Process &process): Process(process) 
     {
	   x_min=x_max=y_min=y_max=0;
	   bin_num=10;
	   
	  setName("Mesh/Export/Histogram Exporter");
	  setDesc("Bin one attribute map based on another attribute map");
	  setIcon(QIcon(":/images/Cluster.png"));

	  addParm("Separate by Parent","Separate by Parent","No",booleanChoice());
	   	   	   
	 }
      bool initialize(QWidget* parent);
      bool OutputHistogram(bool separateParents);

      void getAttrMap(AttrMap<int, double>& data, QString measure);

   protected slots:
     void fillMeasures();
//     bool parseParmsString(QString parmsString);
//     QString createParmsString();
     void changeValue();
   protected:
     QDialog * dlg;
 };


}
#endif
