//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#include <XPIWITParms.hpp>
#include <Information.hpp>

namespace mgx 
{
  bool XPIWITParms::addParm(QString processName, QString parmName, QString parmValue)
  {
    processNames << processName;
    parmNames << parmName;
    parmValues << parmValue;

    return true;
  }

  bool XPIWITParms::update(QDomDocument &doc)
  {
    auto nodeList = doc.elementsByTagName("name");
    for(int i = 0; i < nodeList.size(); i++) {
      auto n = nodeList.at(i);
      QString name = n.toElement().text();
      if(!processNames.contains(name))
        continue;
      while(!(n = n.nextSibling()).isNull()) {
        QString tagName = n.toElement().tagName();
        if(tagName == "arguments") {
          auto argList = n.toElement().elementsByTagName("parameter");
          for(int j = 0; j < argList.size(); j++) {
            auto m = argList.at(j);
            QString argName = m.toElement().attribute("key", "notfound");
            int index = parmNames.indexOf(argName);
            if(index < 0)
              continue;
            m.toElement().setAttribute("value", parmValues[index]);
            Information::out << "Setting arg: " << argName << " to " << m.toElement().attribute("value", "notfound")<< endl;
          }
        }
      }
    }
    return true;
  }
}
