//
// This file is part of MorphoDynamX - http://www.MorphoDynamX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoDynamX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoDynamX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef XPIWITParms_HPP
#define XPIWITParms_HPP

#include <QtXml>

namespace mgx
{
  /// Class to process xml parameter files for XPIWIT
  class XPIWITParms
  {
  public:
    bool addParm(QString processName, QString parmName, QString parmValue);
    bool update(QDomDocument &doc);

  protected:
    QStringList processNames;
    QStringList parmNames;
    QStringList parmValues;
  };
}
#endif
