//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef EXPORT_MESH_TO_FILE_HPP
#define EXPORT_MESH_TO_FILE_HPP

#include <Process.hpp>

namespace mgx 
{
  // Simple export to OBJ
  class ExportMeshToFile : public Process 
  {
  public:
    ExportMeshToFile(const Process& process) : Process(process) 
    {
      setName("Mesh/Export/Export Mesh To File");
      setDesc("Export mesh to a text file for import into other software");
      setIcon(QIcon(":/images/ExportMeshToFile.png"));
    
      addParm("File Name", "File name to save mesh to","");
      addParm("File Type", "Type of file to save", "obj", QStringList() << "obj" << "ply");
    }

    // Standard call interface for all processes
    bool run()
    {
      if(!checkState().mesh(MESH_NON_EMPTY))
        return false;
      return run(currentMesh(), parm("File Name"), parm("File Type"));
    }

    // Initialize the process, used to pop-up a GUI to get the filename
    bool initialize(QWidget* parent);

    // Call interface with parameters used
    bool run(Mesh* mesh, const QString &fileName, const QString &fileType);
  };
}
#endif
