//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#include "ITKMedianImageFilter.hpp"

#include <ITKProgress.hpp>
#include <itkMedianImageFilter.h>

namespace mgx 
{
 bool ITKMedianImageFilter::run(const Store* input, Store* output, Point3u radius)
 {
   UImageConverter::Pointer converter = UImageConverter::New();
 
   converter->SetStore(input);
 
   typedef itk::MedianImageFilter<UImageType, UImageType> FilterType;
   typedef itk::MedianImageFilter<UImageType, UImageType>::InputSizeType RadiusType;
   FilterType::Pointer filter = FilterType::New();
   filter->SetInput(converter->GetOutput());
   RadiusType r = { radius.x(), radius.y(), radius.z() };
   filter->SetRadius(r);
 
   ITKProgress progress("Median Image Filter");
   progress.setFilter(filter);
 
   filter->Update();
 
   UImageType::ConstPointer result = filter->GetOutput();
 
   if(!UImageConverter::TransferImage(output->stack(), output, result))
     throw(QString("ITK Process tried to change the size of the stack"));
 
   output->changed();
   return true;
 }
 REGISTER_PROCESS(ITKMedianImageFilter);
}
