//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef ITK_MEDIAN_IMAGE_FILTERER_HPP
#define ITK_MEDIAN_IMAGE_FILTERER_HPP

#include <ITKProcess.hpp>

namespace mgx 
{
  // Gamma filter on mesh signal, inherit from mesh process
  class ITKMedianImageFilter : public Process 
  {
  public:
    ITKMedianImageFilter(const Process& process) : Process(process) 
    {
      setName("Stack/ITK/Filters/ITK Median Filter");
      setDesc("Perform a median filter with ITK");
      setIcon(QIcon(":/images/ITKMedianImageFilter.png"));

      addParm("Radius", "Radius in voxels in XYZ", "2 2 2");
    }

    // Standard call interface for all processes
    bool run()
    {
      if(!checkState().store(STORE_NON_EMPTY))
        return false;
      Store* input = currentStack()->currentStore();
      if(!input)
        throw QString("%1::run No current store").arg(name());
      Store* output = currentStack()->work();
      if(!output)
        throw QString("%1::run No output store").arg(name());
  
      Point3u radius = stringToPoint3u(parm("Radius"));
      bool res = run(input, output, radius);
      if(res) {
        input->hide();
        output->show();
      }
      return res;
    }
  
    // Call interface with parameters used
    bool run(const Store* input, Store* output, Point3u radius);
  };
}
#endif
