# Plugin name, use this for file and class names
NAME = ITKMedianImageFilter
DEST = user

MGX_LIBS=$$system(MorphoGraphX --lib)
MGX_INCLUDE=$$system(MorphoGraphX --include)
MGX_PROCESSES=$$system(MorphoGraphX --process)
MGX_USER_PROCESSES=$$system(MorphoGraphX --user-process)
CUDA_INCLUDE=/usr/local/cuda/include
CIMG_INCLUDE=
ITK_VERSION=5.0

TEMPLATE = lib

TARGET=usrLib$$NAME

DEFINES += cimg_display=0
SOURCES += $${NAME}.cpp
HEADERS += $${NAME}.hpp
RESOURCES = $${NAME}.qrc

CONFIG += qt release plugin no_plugin_name_prefix

QT += xml opengl gui

*g++* {
QMAKE_CXXFLAGS += -Wno-unused-local-typedefs -std=c++11 -fopenmp
LIBS += -fopenmp
}

INCLUDEPATH += $$MGX_INCLUDE $$MGX_PROCESSES/include $$CUDA_INCLUDE $$CIMG_INCLUDE \
    /usr/include/ITK-$$ITK_VERSION
LIBS += -L$$MGX_LIBS -lmgx -lmgxITKutil -lITKCommon-$$ITK_VERSION

contains(DEST,system) {
  target.path = $$MGX_PROCESSES
} else:contains(DEST,user) {
  target.path = $$MGX_USER_PROCESSES
} else {
  error(Variable DEST must be either \'system\' or \'user\'. Current value is \'$$DEST\')
}
INSTALLS = target

