//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef MESH_GAMMA_FILTER_HPP
#define MESH_GAMMA_FILTER_HPP

#include <Process.hpp>

namespace mgx 
{
  // Gamma filter on mesh signal, inherit from mesh process
  class MeshGammaFilter : public Process 
  {
  public:
    MeshGammaFilter(const Process& process) : Process(process) 
    {
      setName("Mesh/Signal/Gamma Filter");
      setDesc("Run a gamma correction filter on the mesh signal");
      setIcon(QIcon(":/images/GammaFilter.png"));

      addParm("Gamma", "Gamma value, must be positive.", "0.5");
    }

    // Standard call interface for all processes
    bool run()
    {
      return run(currentMesh(), parm("Gamma").toFloat());
    }

    // Call interface with parameters used
    bool run(Mesh* mesh, float gamma);
  };
}
#endif
