//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2021 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef STACK_GAMMA_FILTER_HPP
#define STACK_GAMMA_FILTER_HPP

#include <Process.hpp>

namespace mgx 
{
  // Gamma filter on stack signal, inherit from mesh process
  class StackGammaFilter : public Process 
  {
  public:
    StackGammaFilter(const Process& process) : Process(process) 
    {
      setName("Stack/Filters/Gamma Filter");
      setDesc("Run a gamma correction filter on the stack");
      setIcon(QIcon(":/images/GammaFilter.png"));

      addParm("Gamma", "Gamma value, must be positive.", "0.5");
    }
  
    // Standard call interface for all processes
    bool run()
    {
      Store* input = currentStack()->currentStore();
      if(!input)
        throw QString("%1::run No current store").arg(name());
      Store* output = currentStack()->work();
      if(!output)
        throw QString("%1::run No output store").arg(name());
      bool res = run(input, output, parm("Gamma").toFloat());
      if(res) {
        input->hide();
        output->show();
      }
      return res;
    }
  
    // Call interface with parameters used
    bool run(const Store* input, Store* output, float gamma);
  };
}
#endif
