# Unit testing utility function

# Registers module as a test suite source. All test targets need to start with test_${ADDON}
# Updates GLOBAL PROPERTY called UNIT_TEST_TARGETS with names of this module's targets
Function(Add_Mgx_TestModule MODULE TEST_TARGETS)
  Get_Property(UNIT_TEST_TARGETS GLOBAL PROPERTY UNIT_TEST_TARGETS)
  Set_Property(GLOBAL PROPERTY UNIT_TEST_TARGETS ${UNIT_TEST_TARGETS} ${TEST_TARGETS})
  Add_Custom_Target(${MODULE}_build_tests
    DEPENDS ${TEST_TARGETS}
  )

  Add_Custom_Target(${MODULE}_test
    COMMAND ${CMAKE_CTEST_COMMAND}
  )

  Add_Custom_Target(${MODULE}_check
    COMMAND ${CMAKE_CTEST_COMMAND}
    DEPENDS ${MODULE}_build_tests
  )
EndFunction()

