//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef EDGE_DETECT_ANGLE_HPP
#define EDGE_DETECT_ANGLE_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>

#include <StackProcessMorphology.hpp>

namespace mgx
{
  mgxITK_EXPORT class EdgeDetectAngle : public Process {
  public:
    EdgeDetectAngle(const Process& process) : Process(process) 
    {
	  setName("Stack/Morphology/Edge Detect Angle");
	  setDesc("Do another pass of edge detection with the stack rotated to a new Z direction \n"
	  "This process requires a previous Edge Detect result in the work stack and uses \n"
	  "the parameters from that process");
	  setIcon(QIcon(":/images/EdgeDetectAngle.png"));

	  addParm("Fill Holes","Also run Fill Holes Process","No",booleanChoice());			
	}
  
    bool run()
    {
      if(!checkState().store(STORE_NON_EMPTY | STORE_NON_LABEL))
        return false;
                        
     EdgeDetectProcess *cellTypeMeasures;
     if(!getProcess("Stack/Morphology/Edge Detect", cellTypeMeasures))  
      throw(QString("EdgeDetectAngle: Unable to make EdgeDetectProcess process"));       

     Stack* stack = currentStack();
     Store* main = stack->main();
     Store* work = stack->work();
      
     bool res = run(stack, main, work, cellTypeMeasures->parm("Threshold").toFloat(), cellTypeMeasures->parm("Multiplier").toFloat(), 
                       cellTypeMeasures->parm("Adapt Factor").toFloat(), cellTypeMeasures->parm("Fill Value").toUInt(), 
                                                                                                 stringToBool(parm("Fill Holes")));
      return res;
    }
    bool run(Stack* s1, Store* input, Store* output, float threshold, float multiplier, float factor,
                    uint fillValue, bool fillHoles);
  
  };
}
#endif
