//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef ITKSINK_HPP
#define ITKSINK_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>

namespace mgx
{
  class mgxITK_EXPORT ITKVTKWriter : public Process {
  public:
    ITKVTKWriter(const Process& process) : Process(process) 
    {
	  setName("Stack/ITK/System/ITK VTK Writer");
	  setDesc("Write a VTK Image File");
	  setIcon(QIcon(":/images/save.png"));

	  addParm("Filename","Filename","");
	}
  
    bool run()
    {
      if(!checkState().store(STORE_NON_EMPTY))
        return false;
      Stack* s = currentStack();
      Store* input = s->currentStore();
      bool res = run(input, parm("Filename"));
      return res;
    }
  
    bool run(const Store* input, QString filename);
  };
}

#endif
