//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#include "About.hpp"
#include "Version.hpp"
#include <QThread>
#include <QString>

QString aboutText()
{
  return QString(
    "<h2>MorphoGraphX " VERSION " r" REVISION "</h2>"
    "A tool for 2.5 & 3D cell segmentation, image processing, and more!<br><br>"
    "MorphoGraphX development is led by Richard S. Smith at the John Innes Centre.<br><br>"
    "MorphoGraphX is licensed under the "
    "<html><style type='text/css'></style><a href='http://www.gnu.org/licenses/gpl-2.0.html'>GNU "
    "GPLv2.</a></html><br><br>"
    "Please visit "
    "<html><style type='text/css'></style><a href='http://www.MorphoGraphX.org'>MorphoGraphX.org</a></html>"
    " for more information.<br><br>"
    "If you use MorphoGraphX in your research, please"
    " <html><style type='text/css'></style><a href='http://dx.doi.org/10.7554/eLife.05864'>reference</a></html>"
    " us. MorphoGraphX uses open source libraries from many contributors. Please see the tooltips"
    " for the individual processes to find references to specific algorithms"
    " implemented in MorphoGraphX.<br><br>"
    "Funding support:<dl>"
    "- SystemsX.ch & the Swiss National Science Foundation (SNF)<br>"
    "- German Federal Ministry of Education and Research (BMBF)<br>"
    "- Max Planck Institute for Plant Breeding Research (MPIPZ)<br>"
    "- Human Frontiers Science Program (HFSP)<br>"
    "- The John Innes Centre, Genes in the Environment ISP (BBSRC)<br>");
}

QString introText()
{
  return QString("MorphoGraphX version: " VERSION " revision: " REVISION);
}
