//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef AUTO_TRIM_HPP
#define AUTO_TRIM_HPP

#include <Process.hpp>

namespace mgx 
{
  /**
   * \class AutoTrim AutoTrim.hpp <AutoTrim.hpp>
   *
   * Trim stack boundary box (BBox) to keep only non-empty part. A voxel is
   * considered empty if its intensity is less or equal to the threshold.
   *
   * \ingroup StackProcess
   */
  class mgxBase_EXPORT AutoTrim : public Process {
  public:
    AutoTrim(const Process& process) : Process(process) 
    {
      setName("Stack/Canvas/AutoTrim");
      setDesc("Trim stack boundary box (BBox) to keep only non-empty part.\n"
      "A voxel is considered empty if its intensity is less or equal to the threshold.");
	  setIcon(QIcon(":/images/AutoTrim.png"));
	  
      addParm("Threshold","Voxels below this threshold are considered empty.","0");				
	}
  
    bool run()
    {
      if(!checkState().stack(STACK_ANY))
        return false;
  
      return run(currentStack(), currentStack()->currentStore(), parm("Threshold").toInt());
    }
  
    bool run(Stack* stack, Store* store, int threshold);
  
  };
}
#endif
