//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef CELL_DATA_HPP
#define CELL_DATA_HPP

/**
 * \file CellData.hpp
 *
 * This file contains the definition of a cell.
 */

#include <Config.hpp>
#include <Geometry.hpp>
#include <VVGraph.hpp>
#include <VertexData.hpp>
#include <EdgeData.hpp>
#include <Colors.hpp>

namespace mgx 
{
  /**
   * \class CellData CellData.hpp <CellData.hpp>
   *
   * This class defines the properties of a cell, a vertex in the cell graph.
   */
  class CellData 
  {
  public:
    Point3d pos;     ///< Center position of the cell
    Point3d nrml;    ///< Cell normal
    double area;     ///< Area of the cell
    double volume;   ///< Volume for a 3D cell
    intptr_t vId;    ///< Vertex id in main S graph
    int label;       ///< Cell label
    Colorb color;    ///< Cell center color
    int saveId;      ///< Used when saving
    VVGraph<VertexData, EdgeData> S;  ///< Graph for the cell

    // Constructor, set initial values
    CellData() : pos(0, 0, 0), nrml(0, 0, 0), area(0), volume(0), vId(0),
      label(0), color(0,0,0,0), saveId(0) {}

    ~CellData() {}
  };
}

#endif
