//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef COLOREDITORDLG_HPP
#define COLOREDITORDLG_HPP

#include <Config.hpp>

#include <ui_ColorEditorDlg.h>

namespace mgx 
{
  class Colors;
}

class ColorEditorDlg : public QDialog {
  Q_OBJECT
public:
  ColorEditorDlg(mgx::Colors* colors, QWidget* parent = 0, Qt::WindowFlags f = 0);

protected slots:
  void on_colorsView_doubleClicked(const QModelIndex& idx);
  void on_buttonBox_clicked(QAbstractButton* btn);

protected:
  mgx::Colors* model;
  Ui::ColorEditorDlg ui;
};

#endif
