//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef COLOR_MAP_HPP
#define COLOR_MAP_HPP

#include <Config.hpp>
#include <Color.hpp>

namespace mgx
{
  typedef Vector<2, float> Point2f;
  typedef Vector<4, float> Point4f;

  class mgx_EXPORT ColorMap
  {
  public:
    ColorMap(std::vector<Colorb> *cols, Point2f *bnds) 
      : colorsP(cols), boundsP(bnds) {}
    ColorMap(std::vector<Colorb> *cols) 
      : colorsP(cols), boundsP(0) {}
  
    /// Get color by index
    Colorb getColor(int index) const;
    /// Interpolate color
    Colorb getColor(float s, float sBegin, float sEnd, int iBegin, int iEnd) const;
    Colorb getColor(float s, float sBegin, float sEnd) const;
    Colorb getColor(float s, int iBegin, int iEnd) const;
    Colorb getColor(float s) const;

    /// Set a preset Color Map
    bool setColorMap(const QString &map, uint sz = 0);
    /// Get the list of preset Color Maps
    QStringList getColorMapList() const;
    /// Does Color Map have bounds
    bool hasBounds() const { return boundsP != 0; }

    std::vector<Colorb> &colors() { return *colorsP; }
    const std::vector<Colorb> &colors() const { return *colorsP; }
    Point2f &bounds() { return hasBounds() ? *boundsP : dummyBounds; }
    const Point2f &bounds() const { return hasBounds() ? *boundsP : dummyBounds; }
  
  private:
    std::vector<Colorb> *colorsP;
    Point2f *boundsP;
    Point2f dummyBounds;
  };
}

#endif
