#ifndef MGX_CONFIG_HPP
#define MGX_CONFIG_HPP

#if defined(WIN64) && !defined(WIN32)
  #define WIN32
#endif

#if (defined(_WIN32) || defined(WIN64)) && !defined(WIN32)

  #ifdef mgx_EXPORTS
    #define mgx_EXPORT __declspec(dllexport)
  #else
    #define mgx_EXPORT __declspec(dllimport)
  #endif

  #ifdef mgxBase_EXPORTS
    #define mgxBase_EXPORT __declspec(dllexport)
  #else
    #define mgxBase_EXPORT __declspec(dllimport)
  #endif

  #ifdef mgxPython_EXPORTS
    #define mgxPython_EXPORT __declspec(dllexport)
  #else
    #define mgxPython_EXPORT __declspec(dllimport)
  #endif

  #define WINDOWS
  #include <windows.h>
  #undef max
  #undef min
  #include <cmath>
  #define finite std::isfinite

  #include <float.h>
#else
  #define cuda_EXPORT
  #define mgx_EXPORT
  #define mgxBase_EXPORT
  #define mgxPython_EXPORT
#endif

// Backend to use for operations that should be parallelized but not on GPU
#cmakedefine USE_TBB
#cmakedefine USE_OPENMP

#define THRUST_DEVICE_SYSTEM THRUST_DEVICE_SYSTEM_@THRUST_DEVICE_SYSTEM@
#cmakedefine THRUST_BACKEND_CUDA
#cmakedefine THRUST_BACKEND_OMP
#cmakedefine THRUST_BACKEND_TBB

#cmakedefine MGX_USE_TR1

#cmakedefine MGXPROCPATH "@MGXPROCPATH@"
#cmakedefine MGXPROCINCLPATH "@MGXPROCINCLPATH@"
#cmakedefine MGXDOCPATH "@MGXDOCPATH@"
#cmakedefine MGXRESPATH "@MGXRESPATH@"
#cmakedefine MGXLIBPATH "@MGXLIBPATH@"

#endif

