//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef DIR_HPP
#define DIR_HPP

#include <Config.hpp>

#include <QDir>

namespace mgx 
{
  /// Returns the path relative to the current directory
  mgx_EXPORT QString stripCurrentDir(QString file);
  
  /// Remove a directory from the file path
  mgx_EXPORT QString stripDir(const QString& dir, QString file);
  
  /// Get the directory containing a file (base of the name only)
  mgx_EXPORT QString getDir(QString file);
  
  /// Set the current path
  mgx_EXPORT bool setCurrentPath(const QString& path);
  
  /// Get the current path
  mgx_EXPORT QString currentPath();
  
  /// Get the current path as a directory
  mgx_EXPORT QDir currentDir();
  
  /// Return the absolute path to a file
  mgx_EXPORT QString absoluteFilePath(QString filename);
  
  /// Return the absolute file path, resolving things like environement variables and '~' for $HOME
  mgx_EXPORT QString resolvePath(QString path);
}

#endif
