//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef EDGE_DATA_H
#define EDGE_DATA_H

#include <Config.hpp>
#include <Colors.hpp>

/**
 * \file EdgeData.hpp
 *
 * This file contains the definition of an edge data.
 */
namespace mgx 
{
  /**
   * \class EdgeData EdgeData.hpp <EdgeData.hpp>
   *
   * This class defines the fields in the graph edges.
   */
  struct EdgeData 
  {
    Colorb color;       ///< Color to draw edge

    EdgeData() : color(0,0,0,0) {}
    ~EdgeData() {}
  };
}

#endif
