//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#include "Information.hpp"

#include <QMainWindow>
#include <QStatusBar>
#include <QThread>
#include <QCoreApplication>

#include <iostream>
using namespace std;

#include <QTextStream>
#include <stdio.h>

namespace mgx 
{
  // RSS: Why is debugging defined here?
  bool DEBUG = false;

  namespace Information 
  {
    QTextStream out(stdout);
    QTextStream err(stderr);
    
    static QStatusBar* status = 0;
    
    void init(QMainWindow* wnd)
    {
      status = wnd->statusBar();
      out.setCodec("UTF-8");
      err.setCodec("UTF-8");
    }
    
    void setStatus(const QString& text, bool alsoPrint)
    {
      // Only works from Gui thread
      if(status and status->thread() != QThread::currentThread()) {
        return;
      }
      if(alsoPrint and text.size() > 0)
        out << text << endl;
      if(status != 0)
        status->showMessage(text);
    }
  }
}
