//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef INFORMATION_HPP
#define INFORMATION_HPP

#include <Config.hpp>

#include <QEvent>
#include <QString>
#include <QString>
#include <QTextStream>

class QMainWindow;

// RSS: It would be nice to get rid of this macro
//      processes can use setStatus(QString) instead.
#define SETSTATUS(msg)                             \
  do {                                             \
    QString __status_msg;                          \
    {                                              \
      QTextStream __status_msgstrm(&__status_msg); \
      __status_msgstrm << msg;                     \
    }                                              \
    setStatus(__status_msg); \
  } while(false)

// Convenience macro for debugging
#define DebugOut Information::out << __FILE__ << " " << __LINE__ << endl;

namespace mgx 
{
  mgx_EXPORT extern bool DEBUG;

  namespace Information 
	{
    mgx_EXPORT extern QTextStream out;
    mgx_EXPORT extern QTextStream err;
    
    mgx_EXPORT void init(QMainWindow* wnd);
    mgx_EXPORT void setStatus(const QString& text, bool alsoPrint = true);
  }
}
#endif
