#ifndef LASSOSELECT_H
#define LASSOSELECT_H
#include<vector>
#include<Geometry.hpp>
using mgx::Point3f;

class LassoSelect{
public:
  bool LassoContains(Point3f v){

    int int_count = 0;
    for(uint i=0;i<contour.size();i++){
      Point3f p1 = contour[i];
      Point3f p2 = contour[(i+1)%contour.size()];
      if( (v.y()-p1.y())*(v.y()-p2.y())<0){
        if(v.x()>p1.x() && v.x()>p2.x())
          int_count++;
        else if( (v.x()-p1.x())*(v.x()-p2.x())<0 ){
          float side = ((p2-p1)%(v-p1)).z();
          side *= (p2-p1).y()>0? -1:1;
          if(side>0)
            int_count++;
        }
      }

    }
    return int_count%2;
  }

  void AddPoint(Point3f v){contour.push_back(v);};
  void Clear(){contour.clear();};
  //member variables
  std::vector<Point3f> contour;

};


#endif
