# MakeFile for MorphoGraphX

# Driectories
MGX_BIN = $(shell MorphoGraphX --dir)
MGX_LIB = $(shell MorphoGraphX --libs)
MGX_INCLUDE = $(shell MorphoGraphX --include)
MGX_P_INCLUDE = $(shell MorphoGraphX --process)/include
MGX_PROCESS = $(shell MorphoGraphX --process)
# Flags for compilation
QT_DIR=$(MGX_BIN)/../Qt
CUDA_DIR=$(MGX_BIN)/../cuda
INCLUDES = -I"$(QT_DIR)/mkspecs/linux-g++-64" -I"$(QT_DIR)/include/QtCore" \
  -I"$(QT_DIR)/include/QtGui" -I"$(QT_DIR)/include/QtOpenGL" -I"$(QT_DIR)/include/QtXml" \
  -I"$(QT_DIR)/include" -I"$(MGX_INCLUDE)" -I"$(MGX_P_INCLUDE)" -isystem "$(CUDA_DIR)/include" -I. 
#  -I/usr/X11R6/include 
DEFINES = -Dcimg_display=0 -DQT_NO_DEBUG -DQT_PLUGIN -DQT_XML_LIB -DQT_OPENGL_LIB \
  -DQT_GUI_LIB -DQT_CORE_LIB -DQT_SHARED
CFLAGS = -m64 -pipe -O3 -D_REENTRANT -Wall -W -fPIC $(DEFINES)
CXXFLAGS = -m64 -pipe -Wno-unused-local-typedefs -Wno-system-headers -fopenmp -O3 \
  -D_REENTRANT -Wall -W -std=c++11 $(DEFINES)
LD_FLAGS = -m64 -Wl,-O1 -shared
#LIBS = -L/usr/lib/x86_64-linux-gnu -L/usr/X11R6/lib64 -L/usr/local/lib 
LIBS = -L"$(QT_DIR)/lib" -L"$(MGX_LIB)" -lmgx -L"$(MGX_PROCESS)" -lmgxBase -lQtXml4 -lQtOpenGL4 -lQtGui4 -lQtCore4 -fopenmp -lpthread 

#LD_SO_FLAGS?=  -pipe -mfpmath=sse -msse3 -O3 -rdynamic 
#LD_EXE_FLAGS?=  -pipe -mfpmath=sse -msse3 -O3 -rdynamic 

# Command definitions
CXX = g++
CC = gcc
MOC = moc

RCC = rcc
UIC = uic
RM = rm -f
CP = cp -f

# Compile rules
%.dll:
	$(CXX) -o $@ $^ -shared -Wl,-soname=$@ $(LD_FLAGS) $(LIBS)
#-lGL -lpthread 

%.o: %.cpp
	$(CXX) -c -o $@ $< -fpic $(CXXFLAGS) $(INCLUDES)

%.moc: %.hpp
	$(MOC) -o $@ $<

%.moc: %.cpp $(wildcard %.hpp)
	$(MOC) -o $@ $<

qrc_%.cpp: %.qrc
	$(RCC) -name $(basename $<) -o $@ $<

ui_%.h: %.ui
	$(UIC) -o $@ $<

clean:
	$(RM) *.o *.moc qrc_*.cpp ui_*.h

install:
	$(CP) *.dll $(MGX_PROCESS)

