//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#include <MGXSubdivide.hpp>
#include <Attributes.hpp>

// Process to perform cell division.
namespace mgx
{
  // Propagate edge data
  bool MGXSubdivide::updateEdgeData(vertex l, vertex v, vertex r, double s)
  {
    // Propagate texture info?
    v->color = (1.0 - s) * l->color + s * r->color;
    return true;
  }

  // Propagate cell data
  bool MGXSubdivide::updateCellData(cell c, cell cl, cell cr)
  {
    IntIntAttr &parents = mesh->parents();
    parents[cl->label] = parents[cr->label] = parents[c->label];
    return true;
  }
}
