//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//

#ifndef MGX_SUBDIVIDE_HPP
#define MGX_SUBDIVIDE_HPP

/**
 * \file MGXSubdivide.hpp
 *
 * Subdivide object for built in MGX data
 */

#include <Subdivide.hpp>
#include <Mesh.hpp>

namespace mgx
{
  // Class to subdivide MGX data
  class mgx_EXPORT MGXSubdivide : virtual public Subdivide
  {
    public:
      MGXSubdivide(Mesh *m) : mesh(m) {}

    protected:
      virtual bool updateCellData(cell c, cell cl, cell cr);
      virtual bool updateEdgeData(vertex l, vertex v, vertex r, double s);
    
    private: 
      Mesh *mesh;
  };
}

#endif

