//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef MESH_PROCESSS_TRI_DATA_HPP
#define MESH_PROCESSS_TRI_DATA_HPP

#include <Process.hpp>


namespace mgx
{
  ///\addtogroup MeshProcess
  ///@{
  /**
   * \class StatsTriangleValues <ProcessCellAxis.hpp>
   */
  class mgxBase_EXPORT StatsTriangleValues : public Process 
  {
  public:
    StatsTriangleValues(const Process& process) : Process(process) 
    {
	  setName("Mesh/Triangle Data/Average Tri Value");
	  setDesc("Compute average of triangle values.");
	  setIcon(QIcon(":/images/MakeHeatMap.png"));	

	  addParm("Selection only","Compute only for selected triangles","Yes",booleanChoice());
	  addParm("Statistic","Type of statistic computed","Percentile", QStringList() << "WeightedAverage" << "Percentile");
	  addParm("Percentile","Value for percentile","50");	
	}
		
	bool initialize();  // , QWidget* parent);

    bool run()
    {
      if(!checkState().mesh(MESH_NON_EMPTY))
        return false;
      return run(currentMesh(), stringToBool(parm("Selection only")), parm("Statistic"), parm("Percentile").toFloat());
    }
  
    bool run(Mesh* mesh, bool selection, QString stat, float prc);
  };
}
#endif
