//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef PATHEDITORDLG_HPP
#define PATHEDITORDLG_HPP

#include <Config.hpp>

#include <ui_PathEditorDlg.h>

namespace qglviewer 
{
  class KeyFrameInterpolator;
}

class MGXCamera;

class PathEditorModel : public QAbstractItemModel 
{
  Q_OBJECT
public:
  PathEditorModel(MGXCamera* c, QObject* parent);

  int rowCount(const QModelIndex& parent = QModelIndex()) const;

  int columnCount(const QModelIndex& /*parent*/ = QModelIndex()) const {
    return 1;
  }

  QVariant data(const QModelIndex& index, int role) const;

  QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;

  Qt::ItemFlags flags(const QModelIndex& index) const;

  QModelIndex index(int row, int column, const QModelIndex& parent = QModelIndex()) const;

  QModelIndex parent(const QModelIndex& index) const;

  bool isPath(const QModelIndex& idx) const;

  bool isKeyframe(const QModelIndex& idx) const;

  quint32 pathId(const QModelIndex& idx) const;

  quint32 keyframeId(const QModelIndex& idx) const;

  qglviewer::KeyFrameInterpolator* path(const QModelIndex& idx) const;

  void moveTo(const QModelIndex& idx) const;

  MGXCamera* camera;
};

class PathEditorDlg : public QDialog 
{
  Q_OBJECT
public:
  PathEditorDlg(QWidget* parent, MGXCamera* camera);

protected slots:
  void on_buttonBox_clicked(QAbstractButton* button);
  void on_pathsView_clicked(const QModelIndex& idx);
  void on_pathsView_doubleClicked(const QModelIndex& idx);

private:
  Ui_PathEditorDlg ui;
  mutable MGXCamera* camera;
  PathEditorModel* model;
};

#endif
