//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#ifndef PROGRESS_H
#define PROGRESS_H

#include <Config.hpp>

#include <QEvent>
#include <QList>
#include <QMutex>
#include <QObject>
#include <QPointer>
#include <QString>
#include <QProgressBar>
#include <QLabel>
#include <QToolBar>
#include <QPushButton>
#include <QtCore>
#include <string>

namespace mgx 
{
  // Progress class
  class mgx_EXPORT Progress : public QObject 
  {
    Q_OBJECT
  
    QWidget* _parent;
    QProgressBar* _progressBar;
    QLabel* _progressText;
    QPushButton* _progressStop;
    static Progress* _instance;
  
    bool _canceled;
    int _step;
    int _steps;
    QString _msg;
  
  public:
    Progress();
    ~Progress();

    bool processEvent(QEvent *e);
    void setupProgress(QWidget* parent, QToolBar* progressToolBar);

    void start(const QString& msg, int steps, bool allowCancel = true);
    void start(const char* msg, int steps, bool allowCancel = true)
    {
      start(QString::fromLocal8Bit(msg), steps, allowCancel);
    }
    void start(std::string msg, int steps, bool allowCancel = true)
    {
      start(QString::fromStdString(msg), steps, allowCancel);
    }
    bool advance(int step = -1);
    bool canceled();
    void cancel();
    void stop();
    void setMax(int steps);
    void setMsg(const QString& msg);
    void setMsg(const char* msg) { setMsg(QString::fromLocal8Bit(msg)); }
    void setMsg(std::string msg) { setMsg(QString::fromStdString(msg)); }
  
    static Progress& instance();

  private:
    QString makeMsg() const;
  };

  mgx_EXPORT void progressStart(const QString& msg, int steps = 0, bool allowCancel = true);
  mgx_EXPORT void progressStart(const char* msg, int steps = 0, bool allowCancel = true);
  mgx_EXPORT void progressStart(const std::string &msg, int steps = 0, bool allowCancel = true);
  mgx_EXPORT void progressStop();
  mgx_EXPORT bool progressAdvance(int step = -1);
  mgx_EXPORT bool progressCanceled();
  mgx_EXPORT void progressCancel();
  mgx_EXPORT void progressSetMsg(const QString &msg);
  mgx_EXPORT void progressSetMsg(const char *msg);
  mgx_EXPORT void progressSetMsg(const std::string &msg);
  mgx_EXPORT void progressSetMax(int steps = 0);
}
#endif
