//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef SUBDIVIDE_HPP
#define SUBDIVIDE_HPP

/**
 * \file Subdivide.hpp
 *
 * This file contains an object to inherit from when calling routines that do subdivision
 */
#include <Config.hpp>
#include <Types.hpp>
#include <Information.hpp>

namespace mgx 
{
  class Subdivide
  {
  public:
    Subdivide() {}
    virtual ~Subdivide() {}

    /**
     *  Update data when a cell divides
     *
     * \param c Old cell
     * \param l New cell left (direction is arbitrary)
     * \param r New cell right
     * \param t Adjacent cell on top
     * \param b Adjacent cell on bottom
     */
    virtual bool updateCellData(cell /*c*/, cell /*l*/, cell /*r*/) { return true; }

    /**
     *  Update data when an edge is split
     *
     * \param l Left vertex (direction is arbitrary)
     * \param r Right vertex 
     * \param v New vertex
     * \param s Position of insertion, (0-1) from left to right
     */
    virtual bool updateEdgeData(vertex /*l*/, vertex /*v*/, vertex /*r*/, double /*s*/) { return true; }
  };
}

#endif
