//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
// 
#include "SystemProcess.hpp"
#include "Information.hpp"

namespace mgx 
{
  #define INIT_PROCESS(varName, ClassName) \
    varName(ProcessFactoryPtr(new ClassProcessFactory<ClassName>()), \
                                                  typeid(ClassName).name(), PROCESS_VERSION)
  
  struct SystemRegistration {
    SystemRegistration()
      : INIT_PROCESS(stackImport, StackImport),
        INIT_PROCESS(stackOpen, StackOpen),
        INIT_PROCESS(stackExport, StackExport),
        INIT_PROCESS(stackSave, StackSave),
        INIT_PROCESS(meshImport, MeshImport),
        INIT_PROCESS(meshLoad, MeshLoad),
        INIT_PROCESS(meshExport, MeshExport),
        INIT_PROCESS(meshSave, MeshSave),
        INIT_PROCESS(meshReset, ResetMeshProcess),
        INIT_PROCESS(loadParents, LoadParents),
        INIT_PROCESS(saveParents, SaveParents),
        INIT_PROCESS(resetParents, ResetParents),
        INIT_PROCESS(loadViewFile, LoadViewFile),
        INIT_PROCESS(saveViewFile, SaveViewFile),
        INIT_PROCESS(takeSnapshot, TakeSnapshot) {}
  
    Registration stackImport, stackOpen, stackExport, stackSave, meshImport, meshLoad, 
      meshExport, meshSave, meshReset, loadParents, saveParents, resetParents, loadViewFile, 
      saveViewFile, takeSnapshot;
  };
  
  static SystemRegistration* systemRegistration = 0;
  
  void registerSystemProcesses()
  {
    if(systemRegistration == 0)
      systemRegistration = new SystemRegistration();
  }
  
  void unregisterSystemProcesses()
  {
    if(mgx::DEBUG)
      Information::out << "Trying to unregister system processes" << endl;
    if(systemRegistration)
      delete systemRegistration;
    systemRegistration = 0;
  }
}
