#include <vector>
#include <Geometry.hpp>

// Triangulate a polygon using the triangulation library from Jonathan Richard Shewchuk
// (see cpp file) 
namespace mgx
{
  /*mgx_EXPORT void triangulatePolygon(float maxArea, const std::vector<Point2f> &pList, 
                      const std::vector<Point2i> &segList, std::vector<Point2f> &ptList, 
                      std::vector<Point3i> &triList, std::vector<Point2i> &segtList);*/

  mgx_EXPORT void triangulatePolygon(float maxArea, const std::vector<Point2f> &pList, 
                      const std::vector<Point2i> &segList, std::vector<Point2f> &ptList, 
                      std::vector<Point3i> &triList, std::vector<Point2i> &segtList, bool boundary = false, bool addPointsCenter = true);

  // creates a Delauany triangulation in 2D
  // input: list of points (pList)
  // output: same points (ptList) and triangulation in triList
  mgx_EXPORT void triangulateDelaunay2D(const std::vector<Point2f> &pList, 
                      std::vector<Point2f> &ptList, 
                      std::vector<Point3i> &triList);
}
