//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2015 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef WALL_DATA_H
#define WALL_DATA_H

#include <Config.hpp>
#include <Colors.hpp>

/**
 * \file WallData.hpp
 *
 * This file contains the definition of the wall data. Walls are edges in the cell 
 * graph and summarize the data along the walls between cells.
 */
namespace mgx 
{
  /**
   * \class WallData WallData.hpp <WallData.hpp>
   *
   * This class contains the definition of the wall data. Walls are edges in the cell 
   * graph and summarize the data along the walls between cells.
   */
  struct WallData 
  {
    double length; /// the length of the cell wall
    double area;   /// are of the cell interface
    Colorb color;  /// Wall edge color

    WallData() : length(0), area(0), color(0,0,0,0) {}
    ~WallData() {}
  };
}

#endif
