//
// This file is part of MorphoGraphX - http://www.MorphoGraphX.org
// Copyright (C) 2012-2016 Richard S. Smith and collaborators.
//
// If you use MorphoGraphX in your work, please cite:
//   http://dx.doi.org/10.7554/eLife.05864
//
// MorphoGraphX is free software, and is licensed under under the terms of the 
// GNU General (GPL) Public License version 2.0, http://www.gnu.org/licenses.
//
#ifndef DIST_OBJECT_CUDA_HPP
#define DIST_OBJECT_CUDA_HPP

#include <Cuda.hpp>
#include <ThrustTypes.hpp>

// Public Cuda interface methods
namespace mgx
{
  template<typename T1, typename T2> 
  int mgx_EXPORT copyGPU(T1 *src, T2 *dst)
  {
    if(!src or !dst)
      return 1;
    *dst = *src;

     return 0;
  }

  template<typename T> 
  int mgx_EXPORT allocGPU(T **vec, size_t n)
  {
    if(n == 0) {
      if(*vec) {
        delete *vec;
        *vec = 0;
      }
      return 1;
    }
    if(!*vec)
      *vec = new T;
    (*vec)->resize(n);

    return 0;
  }
} 
#endif
