#!/bin/bash
#
# This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
#
# MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
#
# If you use MorphoGraphX in your work, please cite:
#   https://doi.org/10.7554/eLife.72601
#
# For support please see the image.sc forum:
#   https://forum.image.sc/tag/MorphoGraphX
#
# MorphoGraphX is copyright by its authors, contributors, and/or their employers.
#
# MorphoGraphX is free software, and is licensed under the terms of the 
# GNU General Public License https://www.gnu.org/licenses/.
#

# mdxCNNPredict.sh <CondaDir> <StegmaierDir> <WorkDir> <FileList> <Segment Yes|No>

__conda_setup="$($1'/bin/conda' 'shell.bash' 'hook' 2> /dev/null)"
. $1/etc/profile.d/conda.sh
unset __conda_setup
conda activate pytorch

origDir=`pwd`
mdxDir=$(dirname "$0")
echo "mdxdir:" $mdxDir
echo "stegdir:" $2
cd "$2"
export PYTHONPATH=$PYTHONPATH:"$2"
python "$mdxDir/mdxPredictApply.py" --data_root $3 --test_list $3/$4 --segment $5
cd "$origDir"
