//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//

#ifndef CellCluster_H
#define CellCluster_H

#include <Process.hpp>
#include <Geometry.hpp>
#include <Function.hpp>

namespace mgx {


//typedef std::map<int, double> IntDoubleMap;
typedef std::pair<int, float> IntFloatP;
typedef std::pair<std::map<int, double>, QString> TypeFeatureVector;
//typedef std::set<vertex> vtxSet;
//typedef std::vector<double> vec;
//typedef std::pair<int, int> IntInt;
//typedef std::pair<vertex, vertex> VertexPr;
//typedef std::pair<int, vtxSet> IntVtxSetP;
//typedef std::map<IntInt, vtxSet> loopNhbrElem;
//typedef std::pair<QString, IntFloatAttr> TypeFeatureMap; 

// Attr Maps
// map<int, QStringList> selected Features



class CellCluster {
    public:
    CellCluster() {}
    QString folder;
    std::map<QString, IntFloatAttr> measures;
    std::map<QString, Point2d> scales;
    std::set<int> eliFtrs;
    std::set<QString> SelectedFeaturesName;
};




}


#endif
