//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef COLOR_EDIT_DLG_HPP
#define COLOR_EDIT_DLG_HPP

#include <Config.hpp>

#include <Color.hpp>
#include <ColorMap.hpp>
#include <Misc.hpp>

#include <QAbstractListModel>
#include <vector>
#include <QDialog>

class QAbstractButton;
class QPoint;

class ColorModel : public QAbstractListModel 
{
public:
  ColorModel(std::vector<mgx::Colorb> &colors, mgx::Point2f &bounds);

  int rowCount(const QModelIndex& parent = QModelIndex()) const;
  int columnCount(const QModelIndex& /*parent*/ = QModelIndex()) const { return 1; }

  Qt::ItemFlags flags(const QModelIndex& index) const;

  QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const;
  bool setData(const QModelIndex& index, const QVariant& value, int role = Qt::EditRole);

  void apply();
  void reset();

  void presetColors(const QString &preset);
  void loadPresetColors(const QString &preset);
  void setNbColors(int n);
  void setBoundsMin(float a) { boundsLocal[0] = a; }
  void setBoundsMax(float a) { boundsLocal[1] = a; }

  bool insertRows(int row, int count, const QModelIndex& parent = QModelIndex());
  bool removeRows(int row, int count, const QModelIndex& parent = QModelIndex());

protected:
  std::vector<mgx::Colorb> &colorsDest;
  std::vector<mgx::Colorb> colorsLocal;
  mgx::Point2f &boundsDest;
  mgx::Point2f boundsLocal;
};

namespace Ui 
{
  class ColorEditDlg;
}

class mgx_EXPORT ColorEditDlg : public QDialog 
{
  Q_OBJECT
public:
  ColorEditDlg(mgx::ColorMap &cMap, QWidget* parent);
  ~ColorEditDlg();

public slots:
  //void interpolateColor();

protected slots:
  void on_buttonBox_clicked(QAbstractButton* btn);
  void on_setNbColors_clicked();
  void on_importColors_clicked();
  void on_exportColors_clicked();
  void on_presetColors_currentIndexChanged(QString);
  void on_colorsView_doubleClicked(const QModelIndex &idx);
  //void on_colorsView_customContextMenuRequested(const QPoint &pos);
  void on_minBounds_valueChanged(double d);
  void on_maxBounds_valueChanged(double d);
  void changeNbItems();

signals:
  void update();

protected:
  mgx::ColorMap &colorMap;
  int selectedColor;
  ColorModel* model;
  Ui::ColorEditDlg* ui;
  QAction* interpolateAction;
};

#endif
