//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef CUSTOMMOUSELABELTR_HPP
#define CUSTOMMOUSELABELTR_HPP
  
//#include <CellAtlasConfig.hpp>

#include <QLabel>
#include <QMouseEvent>
#include <QEvent>
#include <QDebug>

class QMouseEvent;

class CustomMouseLabelTR : public QLabel
{
Q_OBJECT
signals:
    void mousePressed( const QPoint& );
    void mouseReleased( const QPoint& );
    void mouseDouble( const QPoint& );
    void keyPressed( const QString& );
    void mouseMove( const QPoint& );
public:
    CustomMouseLabelTR( QWidget* parent = 0, Qt::WindowFlags f = 0 );
    CustomMouseLabelTR( const QString& text, QWidget* parent = 0, Qt::WindowFlags f = 0 );
    virtual ~CustomMouseLabelTR() {}

    void mousePressEvent( QMouseEvent* event );
    void mouseReleaseEvent( QMouseEvent* event );
    void mouseDoubleClickEvent( QMouseEvent* event );
    void mouseMoveEvent( QMouseEvent* event );
    void keyPressEvent( QKeyEvent* event );

};

#endif
