//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef DIST_OBJECT_PROTO_HPP
#define DIST_OBJECT_PROTO_HPP

/**
 * Function prototypes for distributed object library.
 */
#include <ThrustTypes.hpp>

namespace mgx
{
  template<typename T1, typename T2> 
  int copyGPU(T1 *src, T2 *dst);

  template<typename T> 
  int allocGPU(T **vec, size_t n);
}
#endif
