//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef FILELISTWIDGET_HPP
#define FILELISTWIDGET_HPP

#include <Config.hpp>

#include <QListWidget>

namespace mgx 
{
  class FileListWidget : public QListWidget {
    Q_OBJECT
  public:
    FileListWidget(QWidget* parent = 0);
  
  signals:
    void filesDropped(const QStringList& files);
  
  protected:
    void dragEnterEvent(QDragEnterEvent* event);
    void dragMoveEvent(QDragMoveEvent* event);
    void dragLeaveEvent(QDragLeaveEvent* event);
    void dropEvent(QDropEvent* event);
  
    bool handlingDrop;
  };
}
#endif 
