//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef ITKPROGRESS_HPP
#define ITKPROGRESS_HPP

#include <ITKConfig.hpp>

#include <Progress.hpp>
#include <itkCommand.h>
#include <itkProcessObject.h>
#include <itkEventObject.h>

namespace mgx 
{
  class mgxITKutil_EXPORT ITKProgress 
  {
  public:
    ITKProgress(const QString& text);
    ~ITKProgress();
  
    void setFilter(itk::ProcessObject::Pointer filter);
  
    template <typename FilterPointer> void setFilter(const FilterPointer& filter)
    {
      setFilter(itk::ProcessObject::Pointer(filter));
    }
  
    void advance(const itk::EventObject& event);
  
    typedef itk::ReceptorMemberCommand<ITKProgress> Receptor;
    Receptor::Pointer eventHandler;
  
    unsigned long eventTag;
    itk::ProcessObject::Pointer filter;
    itk::ProgressEvent progressEvent;
  };
}

#endif
